/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

public class ApprovalMenuVo extends MosPVo {

	private static final long serialVersionUID = -8867979042858684619L;

	// URL
	private static final String RETURN_URL = "/jsp/workflow/approvalMenu.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/approvalMenu.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/approvalMenu.css";

	// ʃTu^Cg	
	public final String CMD_APPROVAL_MENU 		= "S2800";
	public final String TTL_APPROVAL_MENU 		= CommonConst.TTL_APPROVAL_MASTER;

	// 萔
	public static final int MODE_IMPOSSIBLE 		= 0;
	public static final int MODE_POSSIBLE 		= 1;

	// [h
	protected int mode;

	/**
	 * RXgN^
	 */
	public ApprovalMenuVo() {
		super();
		mode = MODE_IMPOSSIBLE;
		setRetUrl(RETURN_URL);
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
